@echo off
setlocal enabledelayedexpansion

echo Step 1: Starting script...

:: Check if a file was dragged and dropped
if "%~1"=="" (
    echo Error: Please drag and drop a video file onto this script.
    echo Usage: Drag a video file onto this script to trim it.
    pause
    exit /b 1
)

echo Step 2: File check passed...

:: Set input path
set "input=%~1"

echo Step 3: Input set to "%input%"

:: Check if the input file exists
if not exist "%input%" (
    echo Error: Input file "%input%" not found.
    pause
    exit /b 1
)

echo Step 4: Input file exists...

:: Use FFmpeg from the same folder as the script
set "ffmpeg=%~dp0ffmpeg.exe"

echo Step 5: FFmpeg path set to "%ffmpeg%"

:: Check if FFmpeg exists
if not exist "%ffmpeg%" (
    echo Error: ffmpeg.exe not found in the same folder as this script.
    echo Please place ffmpeg.exe in "%~dp0".
    pause
    exit /b 1
)

echo Step 6: FFmpeg exists...

:: Test FFmpeg
echo Step 7: Testing FFmpeg...
"%ffmpeg%" -version
if !errorlevel! neq 0 (
    echo Error: FFmpeg failed to run.
    pause
    exit /b 1
)

echo Step 8: FFmpeg test successful...

:: Prompt user for duration
echo Step 9: Choose duration for the trimmed video:
echo 1. 30 seconds
echo 2. 1 minute
set /p choice="Enter 1 or 2: "

if "%choice%"=="1" (
    set "duration=30"
) else if "%choice%"=="2" (
    set "duration=60"
) else (
    echo Invalid choice, defaulting to 30 seconds.
    set "duration=30"
)

echo Step 10: Duration set to %duration% seconds...

:: Prompt user for output format
echo Step 11: Choose output format:
echo 1. WebM (VP8)
echo 2. MP4 (H.264)
set /p format_choice="Enter 1 or 2: "

:: Set output path and run FFmpeg based on format
if "%format_choice%"=="1" (
    set "output=%~dp0trimmed_%~n1.webm"
    echo Step 12: Output set to "!output!"
    echo Step 13: Trimming "%input%" to %duration% seconds and converting to VP8 WebM...
    "%ffmpeg%" -y -i "%input%" -ss 0 -t %duration% -c:v libvpx -b:v 2M -c:a copy "!output!"
) else if "%format_choice%"=="2" (
    set "output=%~dp0trimmed_%~n1.mp4"
    echo Step 12: Output set to "!output!"
    echo Step 13: Trimming "%input%" to %duration% seconds and converting to H.264 MP4...
    "%ffmpeg%" -y -i "%input%" -ss 0 -t %duration% -c:v libx264 -profile:v baseline -level 3.0 -pix_fmt yuv420p -b:v 5M -c:a aac -b:a 192k "!output!"
) else (
    echo Invalid choice, defaulting to MP4.
    set "output=%~dp0trimmed_%~n1.mp4"
    echo Step 12: Output set to "!output!"
    echo Step 13: Trimming "%input%" to %duration% seconds and converting to H.264 MP4...
    "%ffmpeg%" -y -i "%input%" -ss 0 -t %duration% -c:v libx264 -profile:v baseline -level 3.0 -pix_fmt yuv420p -b:v 5M -c:a aac -b:a 192k "!output!"
)

:: Check if conversion was successful
if !errorlevel! equ 0 (
    echo Step 14: Successfully trimmed and converted "%input%" to "!output!"
) else (
    echo Step 15: Error: Failed to process "%input%".
)

echo Step 16: Script completed.
pause